/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.model.request;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class RenameGroupRequest extends PaginatedModelRequest implements SearchFilterRequest {

    @NotNull
    @Size(min = 1)
    private String newGroupName;

    private boolean leaf;

    private String searchFilter;

    public String getNewGroupName() {
        return newGroupName;
    }

    public void setNewGroupName(String newGroupName) {
        this.newGroupName = newGroupName;
    }

    @Override
    public String getSearchFilter() {
        return searchFilter;
    }

    @Override
    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public boolean isLeaf() {
        return leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }
}
