/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.UserManager;
import it.inaf.ia2.gms.authn.ServletRapClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@Configuration
@EnableTransactionManagement
public class GmsApplication {

    public static void main(String[] args) {
        // Needed to use %5C (backslash URL encoded) in path variables (otherwise BadRequest error is sent)
        System.setProperty("org.apache.catalina.connector.CoyoteAdapter.ALLOW_BACKSLASH", "true");

        SpringApplication.run(GmsApplication.class, args);
    }

    @Bean
    public AuthConfig authConfig() {
        return ServiceLocator.getInstance().getConfig();
    }

    @Bean
    public UserManager userManager() {
        return ServiceLocator.getInstance().getUserManager();
    }

    @Bean
    public ServletRapClient servletRapClient() {
        return (ServletRapClient) ServiceLocator.getInstance().getRapClient();
    }
}
