/*
 * This file is part of gms-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
import VueRouter from 'vue-router';

import Main from './components/Main.vue';
import GenericSearchResults from './components/GenericSearchResults.vue';
import UserSearchResult from './components/UserSearchResult.vue';

export default new VueRouter({
  routes: [{
      path: '/',
      component: Main
    },
    {
      path: '/search',
      component: GenericSearchResults
    },
    {
      path: '/user/:id',
      component: UserSearchResult
    }
  ]
});
