/*
 * This file is part of gms-client
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.BaseGmsClientTest;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class AddMemberTest extends BaseGmsClientTest {

    @BeforeEach
    @Override
    public void init() {
        super.init();
    }

    @Test
    public void testAddMember() {

        CompletableFuture response = CompletableFuture.completedFuture(getMockedResponse(200));

        when(httpClient.sendAsync(any(), any())).thenReturn(response);
        gmsClient.addMember("LBT.INAF", "user");

        verify(httpClient, times(1)).sendAsync(endpointEq("POST", "membership"), any());
    }
}
