/*
 * This file is part of gms-client
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.charset.StandardCharsets;

public class SetPermissionCall extends BaseCall<GmsClient> {

    public SetPermissionCall(GmsClient client) {
        super(client);
    }

    public String setPermission(String completeGroupName, String userId, Permission permission) {

        if (completeGroupName == null) {
            completeGroupName = "";
        }

        HttpRequest.BodyPublisher requestBody = HttpRequest.BodyPublishers.ofString(
                "group=" + URLEncoder.encode(completeGroupName, StandardCharsets.UTF_8)
                + "&user_id=" + userId + "&permission=" + permission);

        HttpRequest groupsRequest = client.newRequest("permission")
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .PUT(requestBody)
                .build();

        return client.call(groupsRequest, BodyHandlers.ofString(), 200, res -> res);
    }
}
