/*
 * This file is part of gms-client
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetMemberEmailAddresses extends BaseCall<GmsClient> {

    public GetMemberEmailAddresses(GmsClient client) {
        super(client);
    }

    public List<String> getMemberEmailAddresses(String group, Permission permission) {

        List<String> emailAddresses = new ArrayList<>();

        String endpoint = "email/" + group;
        if (permission != null) {
            endpoint += "?permission=" + permission;
        }

        HttpRequest request = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return client.call(request, BodyHandlers.ofInputStream(), 200,
                inputStream -> {
                    try ( Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                emailAddresses.add(line);
                            }
                        }
                    }
                    return emailAddresses;
                });
    }
}
