/*
 * This file is part of gms-client
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.charset.StandardCharsets;

public class AddMemberCall extends BaseCall<GmsClient> {

    public AddMemberCall(GmsClient client) {
        super(client);
    }

    public boolean addMember(String completeGroupName, String userId) {

        String endpoint = "membership";

        if (completeGroupName == null) {
            completeGroupName = "";
        }

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .POST(BodyPublishers.ofString(
                        "group=" + URLEncoder.encode(completeGroupName, StandardCharsets.UTF_8)
                        + "&user_id=" + userId))
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200, res -> true);
    }
}
