import os

base_cmd = "java -jar ~/code/ia2-gms/gms-client/gms-cli/target/gms-cli.jar --token-file ~/Downloads/token.txt --config-file ~/code/ia2-gms/gms-client/gms-cli/gms.properties "

def exec(cmd):
    result = os.popen(base_cmd + cmd).read()
    print(result)
    return result

assert exec("create-group test false") == "Group created\n"
assert exec("create-group test.test2 true") == "Group created\n"
assert exec("list-groups test") == "test2\n"

assert exec("add-member test.test2 2386") == "Member added\n"
assert exec("add-permission test.test2 2386 VIEW_MEMBERS") == "Permission added\n"
exec("get-user-permissions 2386")
assert exec("get-group-permissions test.test2") == "2386 VIEW_MEMBERS\n"
exec("get-member-email-addresses test.test2 VIEW_MEMBERS")

exec("get-user-groups 2386")

assert exec("set-permission test.test2 2386 ADMIN") == "Permission changed\n"
assert exec("get-group-permissions test.test2") == "2386 ADMIN\n"

assert exec("delete-permission test.test2 2386") == "Permission removed\n"
assert exec("get-group-permissions test.test2") == ""

exec("remove-member test.test2 2386")
exec("get-member-email-addresses test.test2 VIEW_MEMBERS") == ""

exec("delete-group test.test2")
assert exec("list-groups test") == ""
