# IA2 GMS

## Docker images

Docker images are available on [container registry page](https://www.ict.inaf.it/gitlab/ia2/ia2-gms/container_registry).

A working demo using Docker Compose is available on [RAP repository](https://www.ict.inaf.it/gitlab/ia2/rap-ia2).

## Create the first super-admin

The first super admin user must be added manually, then he/she will be able to add other administrators from the UI:

    INSERT INTO gms_permission (group_id, user_id, permission, group_path) VALUES('ROOT', '1', 'ADMIN', '');

The value `user_id` is the RAP user id.

## Hooks

It is possible to load external jar files in order to extend the GMS with custom functionalities (implementing the *Hook interfaces and annotating the class with `@org.springframework.stereotype.Component`). Currently only the `GroupsHook` is available.

External jar files need to be specified at application startup using the `LOADER_PATH` environment variable (this is a Spring feature).

## Developer notes

Backend and frontend are 2 separate applications:

* the backend is the Maven application in the gms folder, based on Java and Spring Boot;
* the frontend is the npm application is the gms-ui folder, based on Vue.js.

The Maven application automatically packs the Vue.js products inside the final jar, however the frontend application can be tested isolatedly running `npm run serve` in order to take advantage of the npm autoreload functionalities.

By default http calls are mocked inside the Vue.js application.
In order to rely on real server calls edit the .env.development file in this way:

    VUE_APP_API_CLIENT = 'server'
    VUE_APP_API_BASE_URL = 'http://localhost:8081/gms/'

This assumes that your backend runs on 8081 port (with dev profile active, in order to enable the CORS policy) and the frontend runs on 8080 port.
First, do the login using the application running on the 8081 port, then you can access the frontend on the 8080.
