package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import java.util.Optional;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class PermissionsServiceTest {

    @Mock
    private PermissionsDAO permissionsDAO;

    @Mock
    private LoggingDAO loggingDAO;

    @InjectMocks
    private PermissionsService permissionsService;

    @Test
    public void testAddPermissionOverrideOldOne() {

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");

        PermissionEntity existingEntity = new PermissionEntity();
        existingEntity.setGroupId("ROOT");
        existingEntity.setPermission(Permission.VIEW_MEMBERS);

        when(permissionsDAO.findPermissionEntity(eq("ROOT"), eq("user_id")))
                .thenReturn(Optional.of(existingEntity));

        when(permissionsDAO.createOrUpdatePermission(any())).thenAnswer(invocation -> invocation.getArgument(0));

        PermissionEntity result = permissionsService.addPermission(root, "user_id", Permission.ADMIN);

        ArgumentCaptor<PermissionEntity> entityCaptor = ArgumentCaptor.forClass(PermissionEntity.class);
        verify(permissionsDAO, times(1)).createOrUpdatePermission(entityCaptor.capture());
        assertEquals(Permission.ADMIN, entityCaptor.getValue().getPermission());
        assertEquals(Permission.ADMIN, result.getPermission());
    }

    @Test
    public void testAddPermissionNotOverrideOldOne() {

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");

        PermissionEntity existingEntity = new PermissionEntity();
        existingEntity.setGroupId("ROOT");
        existingEntity.setPermission(Permission.MANAGE_MEMBERS);

        when(permissionsDAO.findPermissionEntity(eq("ROOT"), eq("user_id")))
                .thenReturn(Optional.of(existingEntity));

        PermissionEntity result = permissionsService.addPermission(root, "user_id", Permission.VIEW_MEMBERS);

        verify(permissionsDAO, never()).createOrUpdatePermission(any());
        assertEquals(Permission.MANAGE_MEMBERS, result.getPermission());
    }

    @Test
    public void testAddSamePermissionReturnExisting() {

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");

        PermissionEntity existingEntity = new PermissionEntity();
        existingEntity.setGroupId("ROOT");
        existingEntity.setPermission(Permission.VIEW_MEMBERS);

        when(permissionsDAO.findPermissionEntity(eq("ROOT"), eq("user_id")))
                .thenReturn(Optional.of(existingEntity));

        PermissionEntity result = permissionsService.addPermission(root, "user_id", Permission.VIEW_MEMBERS);

        verify(permissionsDAO, never()).createOrUpdatePermission(any());
        assertEquals(Permission.VIEW_MEMBERS, result.getPermission());
    }
}
