package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;

public class AddPermissionCall extends BaseGmsCall {

    public AddPermissionCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean addPermission(String completeGroupName, String userId, Permission permission) {

        String endpoint = "permission";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }

        BodyPublisher requestBody = BodyPublishers.ofString(
                "user_id=" + userId + "&permission=" + permission);

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .POST(requestBody)
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to add permission");
                }).join();
    }
}
