package it.inaf.ia2.gms.client.call;

import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;

public class AddMemberCall extends BaseGmsCall {

    public AddMemberCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean addMember(String completeGroupName, String userId) {

        String endpoint = "membership";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .POST(BodyPublishers.ofString("user_id=" + userId))
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to add member to group");
                }).join();
    }
}
