package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.delete;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class InvitedRegistrationControllerTest {

    @Mock
    private InvitedRegistrationManager manager;

    @InjectMocks
    private InvitedRegistrationController controller;

    private MockMvc mockMvc;

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testDeleteInvitedRegistration() throws Exception {

        mockMvc.perform(delete("/registration?request_id=req1&group_id=group1"))
                .andDo(print())
                .andExpect(status().isNoContent());

        verify(manager, times(1)).deleteInvitedRegistration(eq("req1"), eq("group1"));
    }
}
