package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.UserManager;
import java.net.URI;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.Mock;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class ClientDbFilterTest {

    @Mock
    private HttpServletRequest request;

    @Mock
    private AuthConfig authConfig;

    @Mock
    private UserManager userManager;

    private ClientDbFilter filter;

    @Test
    public void testJwksUriOverride() throws Exception {

        when(authConfig.getRapBaseUri()).thenReturn("http://ia2.inaf.it");
        when(authConfig.getJwksEndpoint()).thenReturn("/jwks?client_name=db0");
        when(request.getSession()).thenReturn(mock(HttpSession.class));
        when(request.getParameter(eq("client_db"))).thenReturn("other_db");

        filter = new ClientDbFilter(authConfig, userManager);
        filter.doFilter(request, mock(HttpServletResponse.class), mock(FilterChain.class));

        verify(userManager).addJwksUri(eq(URI.create("http://ia2.inaf.it/jwks?client_name=other_db")));
    }
}
