package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;

public class SetPermissionCall extends BaseCall<GmsClient> {

    public SetPermissionCall(GmsClient client) {
        super(client);
    }

    public String setPermission(String completeGroupName, String userId, Permission permission) {

        String endpoint = "ws/jwt/permission";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }

        HttpRequest.BodyPublisher requestBody = HttpRequest.BodyPublishers.ofString(
                "user_id=" + userId + "&permission=" + permission);

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .PUT(requestBody)
                .build();

        return client.call(groupsRequest, BodyHandlers.ofString(), 200, res -> res);
    }
}
