package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse.BodyHandlers;

public class CreateGroupCall extends BaseCall<GmsClient> {

    public CreateGroupCall(GmsClient client) {
        super(client);
    }

    public boolean createGroup(String completeGroupName, boolean leaf) {

        HttpRequest groupsRequest = client.newRequest("ws/jwt/" + completeGroupName)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .POST(BodyPublishers.ofString("leaf=" + leaf))
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 201, res -> true);
    }
}
