package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.rap.RapClient;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class KeepAliveController {

    private static final Logger LOG = LoggerFactory.getLogger(KeepAliveController.class);

    @Autowired
    private SessionData sessionData;

    @Autowired
    private RapClient rapClient;

    @GetMapping(value = "/keepAlive", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<?> keepAlive() {
        LOG.trace("Keepalive called");
        if (sessionData.getExpiresIn() < 60) {
            rapClient.refreshToken();
            LOG.trace("RAP token refreshed");
        }
        // empty JSON object response
        return ResponseEntity.ok(new HashMap<>());
    }
}
