package it.inaf.ia2.gms.authn;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.SessionScope;

@Component
@SessionScope
public class SessionData {

    @Autowired
    private HttpServletRequest request;

    private String userId;
    private String userName;
    private String accessToken;
    private String refreshToken;
    private long expiration;

    @PostConstruct
    public void init() {
        CustomAuthenticationData authn = (CustomAuthenticationData) ((OAuth2Authentication) request.getUserPrincipal()).getUserAuthentication();
        userId = (String) authn.getPrincipal();
        userName = (String) authn.getAttributes().get("name");
        accessToken = (String) authn.getAccessToken().getValue();
        refreshToken = authn.getRefreshToken();
        setExpiresIn(authn.getAccessToken().getExpiresIn());
    }

    public String getUserId() {
        return userId;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getUserName() {
        return userName;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiration = System.currentTimeMillis() + expiresIn * 1000;
    }

    public long getExpiresIn() {
        return (expiration - System.currentTimeMillis()) / 1000;
    }
}
