package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.model.Permission;
import it.inaf.ia2.gms.client.model.UserPermission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetUserPermissionsCall extends BaseGmsCall {

    public GetUserPermissionsCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public List<UserPermission> getUserPermissions(String userId) {

        List<UserPermission> userPermissions = new ArrayList<>();

        String endpoint = "permission";
        endpoint += "?user_id=" + userId;

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return response.body();
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to retrieve groups");
                })
                .thenApply(inputStream -> {
                    try (Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                String[] split = line.split(" ");
                                UserPermission userPermission = new UserPermission();
                                userPermission.setGroup(split[0]);
                                userPermission.setPermission(Permission.valueOf(split[1]));
                                userPermissions.add(userPermission);
                            }
                        }
                    }
                    return userPermissions;
                }).join();
    }
}
