package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.gms.client.model.GroupPermission;
import it.inaf.ia2.gms.client.model.Permission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetGroupPermissionsCall extends BaseGmsCall {

    public GetGroupPermissionsCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public List<GroupPermission> getGroupPermissions(String groupId) {

        List<GroupPermission> groupPermissions = new ArrayList<>();

        String endpoint = "permission";
        endpoint += "/" + groupId;

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 200) {
                        return response.body();
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to retrieve groups");
                })
                .thenApply(inputStream -> {
                    try (Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                String[] split = line.split(" ");
                                GroupPermission groupPermission = new GroupPermission();
                                groupPermission.setUserId(split[0]);
                                groupPermission.setPermission(Permission.valueOf(split[1]));
                                groupPermissions.add(groupPermission);
                            }
                        }
                    }
                    return groupPermissions;
                }).join();
    }
}
