package it.inaf.ia2.gms.client.call;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class DeleteGroupCall extends BaseGmsCall {

    public DeleteGroupCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean deleteGroup(String completeGroupName) {

        HttpRequest groupsRequest = newHttpRequest(completeGroupName)
                .header("Accept", "text/plain")
                .DELETE()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 204) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to delete group");
                }).join();
    }
}
