package it.inaf.ia2.gms;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class GmsTestUtils {

    public static void mockPrincipal(HttpServletRequest mockedServletRequest) {
        mockPrincipal(mockedServletRequest, "admin_id");
    }

    public static void mockPrincipal(HttpServletRequest mockedServletRequest, String userId) {
        Principal principal = mock(Principal.class);
        when(principal.getName()).thenReturn(userId);
        when(mockedServletRequest.getUserPrincipal()).thenReturn(principal);
    }
}
