package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import static org.junit.Assert.assertTrue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class GroupsManagerTest {

    @Mock
    private GroupsService groupsService;
    @Mock
    private PermissionsManager permissionsManager;
    @Mock
    private LoggingDAO loggingDAO;

    @InjectMocks
    private GroupsManager groupsManager;

    @Test
    public void testRootAlwaysReadable() {

        GroupEntity root = new GroupEntity();
        root.setName("ROOT");
        root.setId(GroupsService.ROOT);
        root.setPath("");

        groupsManager.verifyUserCanReadGroup(root);
    }

    @Test
    public void testVerifyUserCanReadGroupFails() {

        boolean exception = false;

        GroupEntity group = new GroupEntity();
        group.setName("group_name");
        group.setId("group_id");
        group.setPath("group_id");

        try {
            groupsManager.verifyUserCanReadGroup(group);
        } catch (UnauthorizedException ex) {
            exception = true;
        }

        assertTrue(exception);
    }
}
