package it.inaf.ia2.gms.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.inaf.ia2.gms.GmsTestUtils;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.model.response.SearchResponseItem;
import it.inaf.ia2.gms.model.response.UserSearchResponse;
import it.inaf.ia2.gms.service.SearchService;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class SearchControllerTest {

    @Mock
    private HttpServletRequest servletRequest;

    @Mock
    private SearchService searchService;

    @InjectMocks
    private SearchController controller;

    private MockMvc mockMvc;

    private final ObjectMapper mapper = new ObjectMapper();

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
        GmsTestUtils.mockPrincipal(servletRequest);
    }

    @Test
    public void testGenericSearch() throws Exception {

        PaginatedData<SearchResponseItem> response = new PaginatedData<>(new ArrayList<>(), 1, 10);

        when(searchService.search(any(), any())).thenReturn(response);

        mockMvc.perform(get("/ui/search?query=searchText&paginatorPage=1&paginatorPageSize=10&groups=false")
                .contentType(MediaType.APPLICATION_JSON_VALUE))
                .andExpect(status().isOk());

        verify(searchService, times(1)).search(argThat(req -> {
            assertEquals("searchText", req.getQuery());
            assertEquals(1, req.getPaginatorPage());
            assertEquals(10, req.getPaginatorPageSize());
            assertTrue(req.isUsers());
            assertFalse(req.isGroups());
            return true;
        }), eq("admin_id"));
    }

    @Test
    public void testUserSearch() throws Exception {

        when(searchService.getUserSearchResult(any(), any())).thenReturn(new UserSearchResponse());

        mockMvc.perform(get("/ui/search/user/user_id")
                .contentType(MediaType.APPLICATION_JSON_VALUE))
                .andExpect(status().isOk());

        verify(searchService, times(1)).getUserSearchResult(eq("admin_id"), eq("user_id"));
    }
}
