package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.rap.data.RapUser;
import java.security.Principal;

public class ControllersMockData {

    public static GroupEntity getRoot() {
        GroupEntity root = new GroupEntity();
        root.setId(GroupsService.ROOT);
        root.setName(GroupsService.ROOT);
        root.setPath("");
        return root;
    }

    public static GroupEntity getLbtGroup() {
        GroupEntity lbt = new GroupEntity();
        lbt.setId("lbt_id");
        lbt.setName("LBT");
        lbt.setPath("lbt_id");
        return lbt;
    }

    public static GroupEntity getInafGroup() {
        GroupEntity inaf = new GroupEntity();
        inaf.setId("inaf_id");
        inaf.setName("INAF");
        inaf.setPath("lbt_id.inaf_id");
        return inaf;
    }

    public static GroupEntity getInafProgramGroup() {
        GroupEntity inafProgram = new GroupEntity();
        inafProgram.setId("inaf_p1_id");
        inafProgram.setName("P1");
        inafProgram.setPath("lbt_id.inaf_id.inaf_p1_id");
        return inafProgram;
    }

    public static GroupEntity getPeopleGroup() {
        GroupEntity lbt = new GroupEntity();
        lbt.setId("people_id");
        lbt.setName("people");
        lbt.setPath("people_id");
        return lbt;
    }

    public static GroupEntity getNameSurnameGroup() {
        GroupEntity inaf = new GroupEntity();
        inaf.setId("user_group_id");
        inaf.setName("name.surname");
        inaf.setPath("people_id.user_group_id");
        return inaf;
    }

    public static RapUser getRapUser() {
        RapUser user = new RapUser();
        user.setId("rap_user");
        return user;
    }

    public static Principal getPrincipal() {
        return new Principal() {
            @Override
            public String getName() {
                return "TEST_PRINCIPAL";
            }
        };
    }
}
