package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsTabResponseBuilder {

    @Autowired
    HttpServletRequest servletRequest;

    @Autowired
    private PermissionsManager permissionsManager;

    @Autowired
    private GroupsManager groupsManager;

    @Autowired
    private GroupsService groupsService;

    @Autowired
    private GroupsTreeBuilder groupsListBuilder;

    @Autowired
    private InvitedRegistrationManager invitedRegistrationManager;

    public GroupsTabResponse getGroupsTab(GroupsRequest request) {

        GroupEntity group = groupsService.getGroupById(request.getGroupId());
        groupsManager.verifyUserCanReadGroup(group);

        GroupsTabResponse response = new GroupsTabResponse();

        response.setBreadcrumbs(groupsService.getBreadcrumbs(group.getPath()));

        Permission permission = permissionsManager.getCurrentUserPermission(group);
        response.setPermission(permission);

        response.setGroupsPanel(groupsListBuilder.listSubGroups(group, request, servletRequest.getUserPrincipal().getName()));

        response.setLeaf(group.isLeaf());

        response.setInvitedRegistrations(invitedRegistrationManager.getInvitedRegistrationsForGroup(group));

        return response;
    }
}
