package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.charset.StandardCharsets;

public class RemovePermissionCall extends BaseCall<GmsClient> {

    public RemovePermissionCall(GmsClient client) {
        super(client);
    }

    public boolean removePermission(String completeGroupName, String userId) {

        if (completeGroupName == null) {
            completeGroupName = "";
        }

        String endpoint = "permission?group="
                + URLEncoder.encode(completeGroupName, StandardCharsets.UTF_8)
                + "&user_id=" + userId;

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .DELETE()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 204, res -> true);
    }
}
