package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import it.inaf.ia2.gms.client.model.UserPermission;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class GetUserPermissionsCall extends BaseCall<GmsClient> {

    public GetUserPermissionsCall(GmsClient client) {
        super(client);
    }

    public List<UserPermission> getUserPermissions(String userId) {

        List<UserPermission> userPermissions = new ArrayList<>();

        String endpoint = "permission?user_id=" + userId;

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .GET()
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200,
                inputStream -> {
                    try ( Scanner scan = new Scanner(inputStream)) {
                        while (scan.hasNextLine()) {
                            String line = scan.nextLine();
                            if (!line.isEmpty()) {
                                String[] split = line.split(" ");
                                UserPermission userPermission = new UserPermission();
                                userPermission.setGroup(split[0]);
                                userPermission.setPermission(Permission.valueOf(split[1]));
                                userPermissions.add(userPermission);
                            }
                        }
                    }
                    return userPermissions;
                });
    }
}
