package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class GroupNameServiceTest {

    @Mock
    private GroupsDAO groupsDAO;

    @InjectMocks
    private GroupNameService groupNameService;

    @Test
    public void getNamesTest() {

        mockGroupsDAO();

        List<Map.Entry<String, String>> groupsIdPath = new ArrayList<>();
        groupsIdPath.add(new AbstractMap.SimpleEntry<>("def", "abc.def"));

        Map<String, List<String>> names = groupNameService.getNames(groupsIdPath);
        assertEquals(1, names.size());
        assertEquals(2, names.get("def").size());
        assertEquals("Group 1", names.get("def").get(0));
        assertEquals("Group 2", names.get("def").get(1));
    }

    public void mockGroupsDAO() {

        List<GroupEntity> groups = new ArrayList<>();

        GroupEntity group1 = new GroupEntity();
        group1.setId("abc");
        group1.setName("Group 1");
        group1.setPath("abc");
        groups.add(group1);

        GroupEntity group2 = new GroupEntity();
        group2.setId("def");
        group2.setName("Group 2");
        group2.setPath("abc.def");
        groups.add(group2);

        when(groupsDAO.findGroupsByIds(any())).thenReturn(groups);
    }

    @Test
    public void getRootTest() {

        List<GroupEntity> groups = new ArrayList<>();

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");
        root.setName("Root");
        root.setPath("");
        groups.add(root);

        when(groupsDAO.findGroupsByIds(any())).thenReturn(groups);

        List<Map.Entry<String, String>> groupsIdPath = new ArrayList<>();
        groupsIdPath.add(new AbstractMap.SimpleEntry<>("ROOT", ""));

        Map<String, List<String>> names = groupNameService.getNames(groupsIdPath);
        assertEquals(1, names.size());
        assertEquals(1, names.get("ROOT").size());
        assertEquals("Root", names.get("ROOT").get(0));
    }
}
