package it.inaf.ia2.gms.client.call;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class RemoveMemberCall extends BaseGmsCall {

    public RemoveMemberCall(HttpClientWrapper clientWrapper) {
        super(clientWrapper);
    }

    public boolean removeMember(String completeGroupName, String userId) {

        String endpoint = "membership";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }
        endpoint += "?user_id=" + userId;

        HttpRequest groupsRequest = newHttpRequest(endpoint)
                .header("Accept", "text/plain")
                .DELETE()
                .build();

        return getClient().sendAsync(groupsRequest, HttpResponse.BodyHandlers.ofInputStream())
                .thenApply(response -> {
                    if (response.statusCode() == 204) {
                        return true;
                    }
                    logServerErrorInputStream(groupsRequest, response);
                    throw new IllegalStateException("Unable to remove member from group");
                }).join();
    }
}
