package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import static org.hamcrest.CoreMatchers.notNullValue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class HomePageControllerTest {

    @Mock
    private SessionData session;

    @Mock
    private GroupsTabResponseBuilder groupsTabResponseBuilder;

    @InjectMocks
    private HomePageController controller;

    private MockMvc mockMvc;

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testGetHomePageModel() throws Exception {

        when(session.getUserName()).thenReturn("Name Surname");

        when(groupsTabResponseBuilder.getGroupsTab(any())).thenReturn(new GroupsTabResponse());

        mockMvc.perform(get("/ui/home?groupId=ROOT&paginatorPageSize=20&paginatorPage=1"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.user", notNullValue()));
    }
}
