package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.RapClient;
import it.inaf.ia2.rap.data.RapUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UsersController {

    @Autowired
    private RapClient rapClient;

    @GetMapping(value = "/ui/users", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<List<RapUser>> searchUsers(@RequestParam("search") String searchText) {
        return ResponseEntity.ok(rapClient.getUsers(searchText));
    }
}
