package it.inaf.ia2.gms.model;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RapUser {

    private String id;
    private List<Identity> identities;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Identity> getIdentities() {
        return identities;
    }

    public void setIdentities(List<Identity> identities) {
        this.identities = identities;
    }

    public String getDisplayName() {

        String displayName = null;

        // trying to extract name and surname
        for (Identity identity : identities) {
            if (identity.getName() != null && identity.getSurname() != null) {
                displayName = String.format("%s %s", identity.getName(), identity.getSurname());
                if (identity.isPrimary()) { // prefer always primary
                    break;
                }
            }
        }

        if (displayName == null) { // No name and surname --> using primary email
            displayName = getPrimaryEmail();
        }

        // Adding types
        Set<String> types = identities.stream().map(i -> {
            if (i.getType() == IdentityType.EDU_GAIN && i.getTypedId().endsWith("@ia2.inaf.it")) {
                return "IA2";
            }
            return i.getType().getValue();
        }).collect(Collectors.toSet());
        displayName += String.format(" (%s)", String.join(", ", types));

        return displayName;
    }

    public String getPrimaryEmail() {
        Identity primaryIdentity = identities.stream().filter(i -> i.isPrimary()).findFirst()
                .orElseThrow(() -> new IllegalStateException("No primary identity for user " + id));
        return primaryIdentity.getEmail();
    }
}
