# IA2 GMS

## Database Docker image

To build the image run **from current directory**:

    docker build -f database/Dockerfile --tag gms-db .

To start the image and use the database:

    docker run -d -p 5432:5432 -i -t gms-db:latest

## GMS Docker image

To build the image:

    mvn clean package dockerfile:build -DskipTests

To run:

    docker run --env-file docker-env -d -p 8081:8081 -i -t gms:latest

## Create the first super-admin

The first super admin user must be added manually, then he/she will be able to add other administrators from the UI:

    INSERT INTO gms_permission (group_id, user_id, permission, group_path) VALUES('ROOT', '1', 'ADMIN', '');

The value `user_id` is the RAP user id.

## Developer notes

Backend and frontend are 2 separate applications:

* the backend is the Maven application in the gms folder, based on Java and Spring Boot;
* the frontend is the npm application is the gms-ui folder, based on Vue.js.

The Maven application automatically packs the Vue.js products inside the final jar, however the frontend application can be tested isolatedly running `npm run serve` in order to take advantage of the npm autoreload functionalities.

By default http calls are mocked inside the Vue.js application.
In order to rely on real server calls edit the .env.development file in this way:

    VUE_APP_API_CLIENT = 'server'
    VUE_APP_API_BASE_URL = 'http://localhost:8081/gms/'

This assumes that your backend runs on 8081 port (with dev profile active, in order to enable the CORS policy) and the frontend runs on 8080 port.
First, do the login using the application running on the 8081 port, then you can access the frontend on the 8080.
