package it.inaf.ia2.gms.model;

public enum Permission {

    ADMIN,
    MANAGE_MEMBERS,
    VIEW_MEMBERS,
    TRAVERSE;

    /**
     * Updates the permission keeping the priority (e.g. MANAGE_MEMBERS
     * overrides VIEW_MEMBERS, but not the opposite).
     */
    public static Permission addPermission(Permission oldPermission, Permission newPermission) {

        if (oldPermission == null) {
            return newPermission;
        }

        switch (newPermission) {
            case ADMIN:
                return ADMIN;
            case MANAGE_MEMBERS:
                if (oldPermission != Permission.ADMIN) {
                    return MANAGE_MEMBERS;
                }
            case VIEW_MEMBERS:
                if (oldPermission == Permission.TRAVERSE) {
                    return VIEW_MEMBERS;
                }
        }

        return oldPermission;
    }
}
