package it.inaf.ia2.gms.manager;

import it.inaf.ia2.gms.authn.RapPrincipal;
import it.inaf.ia2.gms.authn.SessionData;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class UserAwareComponent {

    @Autowired(required = false)
    private SessionData session;

    @Autowired
    private HttpServletRequest request;

    protected String getCurrentUserId() {
        if (request.getUserPrincipal() != null && request.getUserPrincipal() instanceof RapPrincipal) {
            return request.getUserPrincipal().getName();
        } else {
            return session.getUserId();
        }
    }
}
