package it.inaf.ia2.gms.cli;

import it.inaf.ia2.gms.client.GmsClient;
import it.inaf.ia2.gms.client.model.Permission;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CLI {

    private final GmsClient client;

    public static void main(String[] args) throws Exception {
        new CLI().run(args);
    }

    private CLI() throws IOException {

        File config = new File("gms.properties");
        if (!config.exists()) {
            System.err.println("Unable to find the file gms.properties");
            System.exit(1);
        }

        Properties properties = new Properties();
        try (InputStream in = new FileInputStream(config)) {
            properties.load(in);
        }

        String baseUrl = (String) properties.get("base_url");
        if (baseUrl == null) {
            System.err.println("Missing base_url in gms.properties");
            System.exit(1);
        }

        String token = (String) properties.get("token");
        if (token == null) {
            System.err.println("Missing token in gms.properties");
            System.exit(1);
        }

        client = new GmsClient(baseUrl).setAccessToken(token);
    }

    public void run(String... args) throws Exception {
        if (args.length < 2) {
            displayUsage();
        }

        switch (args[0]) {
            case "create-group":
                boolean leaf = false;
                if (args.length > 1) {
                    leaf = Boolean.parseBoolean(args[2]);
                }
                client.createGroup(args[1], leaf);
                System.out.println("Group created");
                break;
            case "delete-group":
                client.deleteGroup(args[1]);
                System.out.println("Group deleted");
                break;
            case "add-member":
                if (args.length < 3) {
                    displayUsage();
                }
                client.addMember(args[1], args[2]);
                System.out.println("Member added");
                break;
            case "remove-member":
                if (args.length < 3) {
                    displayUsage();
                }
                client.removeMember(args[1], args[2]);
                System.out.println("Member removed");
                break;
            case "add-permission":
                if (args.length < 4) {
                    displayUsage();
                }
                client.addPermission(args[1], args[2], Permission.valueOf(args[3]));
                System.out.println("Permission added");
                break;
            case "delete-permission":
                if (args.length < 4) {
                    displayUsage();
                }
                client.removePermission(args[1], args[2]);
                System.out.println("Permission removed");
                break;
            default:
                displayUsage();
                break;
        }
    }

    private void displayUsage() {
        System.out.println("java -jar gms-client.jar\n"
                + "    create-group <name1.name2.name3> <leaf>\n"
                + "    delete-group <name1.name2.name3>\n"
                + "    add-member <name1.name2.name3> <user_id>\n"
                + "    remove-member <name1.name2.name3> <user_id>\n"
                + "    add-permission <name1.name2.name3> <user_id> <permission>\n"
                + "    delete-permission <name1.name2.name3> <user_id>");
        System.exit(0);
    }
}
