package it.inaf.ia2.gms.client.call;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.Builder;

public class HttpClientWrapper {

    private final String baseGmsUri;
    private final HttpClient client;

    private String accessToken;

    public HttpClientWrapper(String baseGmsUri) {
        String uri = baseGmsUri;
        if (!uri.endsWith("/")) {
            uri += "/";
        }
        this.baseGmsUri = uri;

        this.client = HttpClient.newBuilder()
                .followRedirects(HttpClient.Redirect.ALWAYS)
                .build();
    }

    public HttpClientWrapper setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    Builder newHttpRequest(String endpoint) {
        return HttpRequest.newBuilder()
                .uri(URI.create(baseGmsUri + endpoint))
                .header("Authorization", "Bearer " + accessToken);
    }

    HttpClient getClient() {
        return client;
    }
}
