package it.inaf.ia2.gms.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.gms.client.GmsClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse.BodyHandlers;

public class AddMemberCall extends BaseCall<GmsClient> {

    public AddMemberCall(GmsClient client) {
        super(client);
    }

    public boolean addMember(String completeGroupName, String userId) {

        String endpoint = "ws/jwt/membership";
        if (completeGroupName != null && !completeGroupName.isBlank()) {
            endpoint += "/" + completeGroupName;
        }

        HttpRequest groupsRequest = client.newRequest(endpoint)
                .header("Accept", "text/plain")
                .header("Content-Type", "application/x-www-form-urlencoded")
                .POST(BodyPublishers.ofString("user_id=" + userId))
                .build();

        return client.call(groupsRequest, BodyHandlers.ofInputStream(), 200, res -> true);
    }
}
