#ifndef CONFIGURATION_H
#define	CONFIGURATION_H

#include <boost/shared_ptr.hpp>

namespace DataImporter_ns
{

class Configuration
{
public:
//------------------------------------------------------------------------------
//	[Public] Shared pointer typedef
//------------------------------------------------------------------------------
	typedef boost::shared_ptr<Configuration> SP;

private:
//------------------------------------------------------------------------------
//	[Private] Constructor destructor deleter
//------------------------------------------------------------------------------
	Configuration(std::string certificateFile, std::string storagePath,
        std::string remoteHost, unsigned int remotePort,
        std::string remoteUsername, std::string remotePassword,
        std::string databaseHost, unsigned int databasePort,
        std::string databaseUsername, std::string databasePassword,
        std::string databaseSchema, std::string databaseTable,
        unsigned int refreshTime, unsigned int timeout, unsigned int recoveryTime,
        std::string auxDatabaseHost, unsigned int auxDatabasePort,
        std::string auxDatabaseUsername, std::string auxDatabasePassword,
        std::string auxDatabaseSchema, std::string auxDatabaseTimestampTable,
        std::string auxDatabaseFailedTable, std::string whereCondition) :
        m_certificateFile (certificateFile), m_storagePath(storagePath),
        m_remoteHost(remoteHost), m_remotePort(remotePort),
        m_remoteUsername(remoteUsername), m_remotePassword(remotePassword),
        m_databaseHost(databaseHost), m_databasePort(databasePort),
        m_databaseUsername(databaseUsername),
        m_databasePassword(databasePassword), m_databaseSchema(databaseSchema),
		m_databaseTable(databaseTable), m_refreshTime(refreshTime),
		m_timeout(timeout), m_recoveryTime(recoveryTime),
        m_auxDatabaseHost(auxDatabaseHost), m_auxDatabasePort(auxDatabasePort),
        m_auxDatabaseUsername(auxDatabaseUsername),
        m_auxDatabasePassword(auxDatabasePassword),
        m_auxDatabaseSchema(auxDatabaseSchema),
        m_auxDatabaseTimestampTable(auxDatabaseTimestampTable),
        m_auxDatabaseFailedTable(auxDatabaseFailedTable),
        m_whereCondition(whereCondition) { };

	virtual ~Configuration() {}

	class Deleter;
	friend class Deleter;
	class Deleter
	{
	public:
		void operator()(Configuration* c) { delete c; }
	};

public:
//------------------------------------------------------------------------------
//	[Public] Create class method
//------------------------------------------------------------------------------
	static Configuration::SP create(std::string certificateFile,
        std::string storagePath, std::string remoteHost, unsigned int remotePort,
        std::string remoteUsername, std::string remotePassword,
        std::string databaseHost, unsigned int databasePort,
        std::string databaseUsername, std::string databasePassword,
        std::string databaseSchema, std::string databaseTable,
        unsigned int refreshTime, unsigned int timeout, unsigned int recoveryTime,
        std::string auxDatabaseHost, unsigned int auxDatabasePort,
        std::string auxDatabaseUsername, std::string auxDatabasePassword,
        std::string auxDatabaseSchema, std::string auxDatabaseTimestampTable,
        std::string auxDatabaseFailedTable, std::string whereCondition)
	{
		Configuration::SP c_sp(new Configuration(certificateFile, storagePath,
            remoteHost, remotePort, remoteUsername, remotePassword, databaseHost,
            databasePort, databaseUsername, databasePassword, databaseSchema,
            databaseTable, refreshTime, timeout, recoveryTime, auxDatabaseHost,
            auxDatabasePort, auxDatabaseUsername, auxDatabasePassword,
            auxDatabaseSchema, auxDatabaseTimestampTable, auxDatabaseFailedTable,
            whereCondition), Configuration::Deleter());

		return c_sp;
	}

//------------------------------------------------------------------------------
//	[Public] Getter methods
//------------------------------------------------------------------------------
	std::string	getCertificateFile() const { return m_certificateFile; }
    std::string getStoragePath() const { return m_storagePath; }
	std::string	getRemoteHost() const { return m_remoteHost; }
	unsigned int getRemotePort() const { return m_remotePort; }
	std::string	getRemoteUsername() const { return m_remoteUsername; }
	std::string	getRemotePassword() const { return m_remotePassword; }
	std::string	getDatabaseHost() const { return m_databaseHost; }
	unsigned int getDatabasePort() const { return m_databasePort; }
	std::string	getDatabaseUsername() const { return m_databaseUsername; }
	std::string	getDatabasePassword() const { return m_databasePassword; }
	std::string	getDatabaseSchema() const { return m_databaseSchema; }
	std::string	getDatabaseTable() const { return m_databaseTable; }
	unsigned int getRefreshTime() const { return m_refreshTime; }
	unsigned int getTimeout() const { return m_timeout; }
    unsigned int getRecoveryTime() const { return m_recoveryTime; }
    std::string getAuxDatabaseHost() const { return m_auxDatabaseHost; }
    unsigned int getAuxDatabasePort() const { return m_auxDatabasePort; }
    std::string getAuxDatabaseUsername() const { return m_auxDatabaseUsername; }
    std::string getAuxDatabasePassword() const { return m_auxDatabasePassword; }
    std::string getAuxDatabaseSchema() const { return m_auxDatabaseSchema; }
    std::string getAuxDatabaseTimestampTable() const { return m_auxDatabaseTimestampTable; }
    std::string getAuxDatabaseFailedTable() const { return m_auxDatabaseFailedTable; }
    std::string getWhereCondition() const { return m_whereCondition; }

private:
//------------------------------------------------------------------------------
//	[Private] class variables
//------------------------------------------------------------------------------
	//Absolute path to certificate chain file
	const std::string m_certificateFile;

	//Absolute path to storage
	const std::string m_storagePath;

    //Metadata exporter remote host
	const std::string	m_remoteHost;

    //Metadata exporter remote port
	const unsigned int m_remotePort;

    //Metadata exporter login username
	const std::string	m_remoteUsername;

    //Metadata exporter remote password
	const std::string	m_remotePassword;

    //Metadata local database host
	const std::string	m_databaseHost;

    //Metadata local database port
	const unsigned int m_databasePort;

    //Metadata local database username
	const std::string	m_databaseUsername;

    //Metadata local database password
	const std::string	m_databasePassword;

    //Metadata local database schema
	const std::string	m_databaseSchema;

    //Metadata local database table
	const std::string	m_databaseTable;

    //Remote database request period (seconds)
	const unsigned int m_refreshTime;

	//Connection timeout (seconds)
	const unsigned int m_timeout;

    //Recovery time (seconds)
    const unsigned int m_recoveryTime;

	//Auxiliary database host
	const std::string m_auxDatabaseHost;

	//Auxiliary database port
	const unsigned int m_auxDatabasePort;

	//Auxiliary database username
	const std::string m_auxDatabaseUsername;

	//Auxiliary database password
	const std::string m_auxDatabasePassword;

	//Auxiliary database schema
	const std::string m_auxDatabaseSchema;

	//Auxiliary database timestamp table
	const std::string m_auxDatabaseTimestampTable;

	//Auxiliary database failed table
	const std::string m_auxDatabaseFailedTable;

	//Files retrieval where condition
    const std::string m_whereCondition;
};

}   //End of namespace

#endif	/* CONFIGURATION_H */

