#ifndef PROTOCOLMANAGER_H
#define	PROTOCOLMANAGER_H

#include <Response.pb.h>
#include <Request.pb.h>
#include <Configuration.h>
#include <DBManager.h>
#include <FileWrapper.h>

#include <tango.h>

#include <boost/date_time.hpp>

namespace DataImporter_ns
{

class DataImporter;

//Protocol buffer request class shared pointer
typedef boost::shared_ptr<Request> RequestSP;

//Protocol buffer response class shared pointer
typedef boost::shared_ptr<Response> ResponseSP;

class ProtocolManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<ProtocolManager> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    ProtocolManager(DataImporter*, Configuration::SP, DBManager::SP);

    virtual ~ProtocolManager();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
            void operator()(ProtocolManager* p) { delete p; }
    };

public:
//------------------------------------------------------------------------------
//  [Public] Class creation method
//------------------------------------------------------------------------------
    static ProtocolManager::SP create(DataImporter*, Configuration::SP,
        DBManager::SP);

//------------------------------------------------------------------------------
//  [Public] Remote endpoint setter method
//------------------------------------------------------------------------------
    virtual void setRemoteEndpoint(std::string);

//------------------------------------------------------------------------------
//  [Public] Files lists methods
//------------------------------------------------------------------------------
    virtual void retrieveFiles() throw(std::runtime_error);

    virtual bool hasFilesToTransfer();
    
    virtual bool hasNextFile();

//------------------------------------------------------------------------------
//  [Public] Request response methods
//------------------------------------------------------------------------------
    RequestSP createtRequest()
        throw(std::runtime_error);

    FileWrapper::SP processResponse(ResponseSP)
        throw(std::logic_error, std::runtime_error);

//------------------------------------------------------------------------------
//  [Public] Files status methods
//------------------------------------------------------------------------------
    virtual void setCurrentFileDownloaded(FileWrapper::SP)
        throw(std::runtime_error);

    virtual void setCurrentFileFailed()
        throw(std::runtime_error);

protected:
//------------------------------------------------------------------------------
//  [Protected] Elapsed recovery time method
//------------------------------------------------------------------------------
    virtual bool isRecoveryTimeElapsed();
	
//------------------------------------------------------------------------------
//  [Protected] Fill request utility method
//------------------------------------------------------------------------------
	virtual RequestSP fillRequest(DBManager::FileRowset::const_iterator)
		throw(std::runtime_error);
    
//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Tango server class pointer
    DataImporter* m_dataImporter_p;

    //Configuration parameters shared pointer
    Configuration::SP m_configuration_sp;

    //Database manger shared pointer
    DBManager::SP m_dBManager_sp;

    //Address and port of remote endpoint
    std::string m_remoteEndpoint;

    //Processing file from failed list last timestamp
    boost::posix_time::ptime m_recoveryModeTime;

    //New file list shared pointer
    DBManager::FileRowsetSP m_newFileRowset_sp;

    //New file list iterator
    DBManager::FileRowset::const_iterator m_newFileRowsetIt;

    //Failed file list shared pointer
    DBManager::FileRowsetSP m_failedFileRowset_sp;

    //Failed file list iterator
    DBManager::FileRowset::const_iterator m_failedFileRowsetIt;
};

}   //End of namespace

#endif	/* PROTOCOLMANAGER_H */

