#ifndef PLAINCLIENT_H
#define	PLAINCLIENT_H

#include <Client.h>

namespace DataImporter_ns
{

class PlainClient : public Client
{
protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor
//------------------------------------------------------------------------------
    PlainClient(DataImporter*, Configuration::SP);

    virtual ~PlainClient();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
                void operator()(PlainClient* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//  [Public] Class creation method
//------------------------------------------------------------------------------
    static Client::SP create(DataImporter*, Configuration::SP);

protected:
//------------------------------------------------------------------------------
//  [Protected] Connection initialization methods
//------------------------------------------------------------------------------
    virtual void startConnect(boost::asio::ip::tcp::resolver::iterator);

    virtual void handleConnect(const boost::system::error_code&,
        boost::asio::ip::tcp::resolver::iterator);

//------------------------------------------------------------------------------
//  [Protected] Request response methods
//------------------------------------------------------------------------------
    virtual void startWriteRequest();

    virtual void startReadResponseHeader();

    virtual void startReadResponseBody(boost::uint32_t);

    virtual void startReadData(FileWrapper::SP);

//------------------------------------------------------------------------------
//  [Protected] Connection close method
//------------------------------------------------------------------------------
    virtual void closeConnection();

//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Plain connection socket
    boost::asio::ip::tcp::socket m_plainSocket;
};

}   //End of namespace

#endif	/* PLAINCLIENT_H */

