/*----- PROTECTED REGION ID(DataImporterStateMachine.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        DataImporterStateMachine.cpp
//
// description : State machine file for the DataImporter class
//
// project :     Data importer
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#include <DataImporter.h>

/*----- PROTECTED REGION END -----*/	//	DataImporter::DataImporterStateMachine.cpp

//================================================================
//  States   |  Description
//================================================================
//  ON       |  Data exporter is in ON state (searching new file to transfer)
//  OFF      |  Data exporter is in OFF state (not searching for file to transfer)
//  FAULT    |  Data exporter is in FAULT state (configuration error occurred)
//  ALARM    |  Data exporter is in ALARM state (runtime error occured)
//  RUNNING  |  Data exporter is in RUNNING state (file transfer in progress)


namespace DataImporter_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : DataImporter::is_RegularFileCounter_allowed()
 *	Description : Execution allowed for RegularFileCounter attribute
 */
//--------------------------------------------------------
bool DataImporter::is_RegularFileCounter_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for RegularFileCounter attribute in read access.
	/*----- PROTECTED REGION ID(DataImporter::RegularFileCounterStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataImporter::RegularFileCounterStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::is_FailedFileCounter_allowed()
 *	Description : Execution allowed for FailedFileCounter attribute
 */
//--------------------------------------------------------
bool DataImporter::is_FailedFileCounter_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for FailedFileCounter attribute in read access.
	/*----- PROTECTED REGION ID(DataImporter::FailedFileCounterStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataImporter::FailedFileCounterStateAllowed_READ
	return true;
}

//=================================================
//		Commands Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : DataImporter::is_On_allowed()
 *	Description : Execution allowed for On attribute
 */
//--------------------------------------------------------
bool DataImporter::is_On_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::ON ||
		get_state()==Tango::FAULT ||
		get_state()==Tango::ALARM ||
		get_state()==Tango::RUNNING)
	{
	/*----- PROTECTED REGION ID(DataImporter::OnStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataImporter::OnStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::is_Off_allowed()
 *	Description : Execution allowed for Off attribute
 */
//--------------------------------------------------------
bool DataImporter::is_Off_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::OFF ||
		get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(DataImporter::OffStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataImporter::OffStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::is_ResetCounter_allowed()
 *	Description : Execution allowed for ResetCounter attribute
 */
//--------------------------------------------------------
bool DataImporter::is_ResetCounter_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for ResetCounter command.
	/*----- PROTECTED REGION ID(DataImporter::ResetCounterStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataImporter::ResetCounterStateAllowed
	return true;
}

}	//	End of namespace
