/*----- PROTECTED REGION ID(DataExporter.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        DataExporter.cpp
//
// description : C++ source for the DataExporter class and its commands.
//               The class is derived from Device. It represents the
//               CORBA servant object which will be accessed from the
//               network. All commands which can be executed on the
//               DataExporter are implemented in this file.
//
// project :     Data exporter
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <DataExporter.h>
#include <DataExporterClass.h>
#include <PlainServer.h>
#include <SSLServer.h>

#include <boost/filesystem.hpp>

/*----- PROTECTED REGION END -----*/	//	DataExporter.cpp

/**
 *  DataExporter class description:
 *
 */

//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name  |  Method name
//================================================================
//  State         |  Inherited (no method)
//  Status        |  Inherited (no method)
//  On            |  on
//  Off           |  off
//================================================================

//================================================================
//  Attributes managed is:
//================================================================
//================================================================

namespace DataExporter_ns
{
/*----- PROTECTED REGION ID(DataExporter::namespace_starting) ENABLED START -----*/

//	static initializations

/*----- PROTECTED REGION END -----*/	//	DataExporter::namespace_starting

//--------------------------------------------------------
/**
 *	Method      : DataExporter::DataExporter()
 *	Description : Constructors for a Tango device
 *                implementing the classDataExporter
 */
//--------------------------------------------------------
DataExporter::DataExporter(Tango::DeviceClass *cl, string &s)
 : TANGO_BASE_CLASS(cl, s.c_str())
{
	/*----- PROTECTED REGION ID(DataExporter::constructor_1) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	DataExporter::constructor_1
}
//--------------------------------------------------------
DataExporter::DataExporter(Tango::DeviceClass *cl, const char *s)
 : TANGO_BASE_CLASS(cl, s)
{
	/*----- PROTECTED REGION ID(DataExporter::constructor_2) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	DataExporter::constructor_2
}
//--------------------------------------------------------
DataExporter::DataExporter(Tango::DeviceClass *cl, const char *s, const char *d)
 : TANGO_BASE_CLASS(cl, s, d)
{
	/*----- PROTECTED REGION ID(DataExporter::constructor_3) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	DataExporter::constructor_3
}

//--------------------------------------------------------
/**
 *	Method      : DataExporter::delete_device()
 *	Description : will be called at device destruction or at init command
 */
//--------------------------------------------------------
void DataExporter::delete_device()
{
	DEBUG_STREAM << "DataExporter::delete_device() " << device_name << endl;
	/*----- PROTECTED REGION ID(DataExporter::delete_device) ENABLED START -----*/

	//	Delete device allocated objects

	/*----- PROTECTED REGION END -----*/	//	DataExporter::delete_device
}

//--------------------------------------------------------
/**
 *	Method      : DataExporter::init_device()
 *	Description : will be called at device initialization.
 */
//--------------------------------------------------------
void DataExporter::init_device()
{
	DEBUG_STREAM << "DataExporter::init_device() create device " << device_name << endl;
	/*----- PROTECTED REGION ID(DataExporter::init_device_before) ENABLED START -----*/

    set_state(Tango::INIT);
    set_status("Initializing device");

	/*----- PROTECTED REGION END -----*/	//	DataExporter::init_device_before


	//	Get the device properties from database
	get_device_property();


	/*----- PROTECTED REGION ID(DataExporter::init_device) ENABLED START -----*/

    if(get_state() != Tango::FAULT)
    {
        try
        {
            if(enableSSL)
                m_server_sp = SSLServer::create(this, m_configuration_sp);
            else
                m_server_sp = PlainServer::create(this, m_configuration_sp);

            //Start device if auto start enabled
            if(autoStart)
            {
                INFO_STREAM << "FitsImporter::init_device() auto start enabled " << endl;
                on();
            }
        }
        catch(std::exception& ex)
        {
            set_state(Tango::FAULT);
            std::stringstream error_stream;
            error_stream << "DataExporter::init_device() " << ex.what() << std::endl;
            set_status(error_stream.str());
        }
        catch(...)
        {
            set_state(Tango::FAULT);
            set_status("DataExporter::init_device() unknown error");
        }
    }

	/*----- PROTECTED REGION END -----*/	//	DataExporter::init_device
}

//--------------------------------------------------------
/**
 *	Method      : DataExporter::get_device_property()
 *	Description : Read database to initialize property data members.
 */
//--------------------------------------------------------
void DataExporter::get_device_property()
{
	/*----- PROTECTED REGION ID(DataExporter::get_device_property_before) ENABLED START -----*/

    //Exported tables multi map [schema table]
    std::multimap<const std::string, const std::string> exportedTablesMap;

    //Authorised user map [user password]
    std::map<const std::string, const std::string> authorisedUsersMap;

	/*----- PROTECTED REGION END -----*/	//	DataExporter::get_device_property_before


	//	Read device properties from database.
	Tango::DbData	dev_prop;
	dev_prop.push_back(Tango::DbDatum("CertificateFile"));
	dev_prop.push_back(Tango::DbDatum("PrivateKeyFile"));
	dev_prop.push_back(Tango::DbDatum("DHTempFile"));
	dev_prop.push_back(Tango::DbDatum("ExportedTables"));
	dev_prop.push_back(Tango::DbDatum("AuthorisedUsers"));
	dev_prop.push_back(Tango::DbDatum("LocalHost"));
	dev_prop.push_back(Tango::DbDatum("LocalPort"));
	dev_prop.push_back(Tango::DbDatum("WorkerNumber"));
	dev_prop.push_back(Tango::DbDatum("EnableSSL"));
	dev_prop.push_back(Tango::DbDatum("DatabaseHost"));
	dev_prop.push_back(Tango::DbDatum("DatabasePort"));
	dev_prop.push_back(Tango::DbDatum("DatabaseUsername"));
	dev_prop.push_back(Tango::DbDatum("DatabasePassword"));
	dev_prop.push_back(Tango::DbDatum("DatabaseConnectionNumber"));
	dev_prop.push_back(Tango::DbDatum("AutoStart"));

	//	is there at least one property to be read ?
	if (dev_prop.size()>0)
	{
		//	Call database and extract values
		if (Tango::Util::instance()->_UseDb==true)
			get_db_device()->get_property(dev_prop);

		//	get instance on DataExporterClass to get class property
		Tango::DbDatum	def_prop, cl_prop;
		DataExporterClass	*ds_class =
			(static_cast<DataExporterClass *>(get_device_class()));
		int	i = -1;

		//	Try to initialize CertificateFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  certificateFile;
		else {
			//	Try to initialize CertificateFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  certificateFile;
		}
		//	And try to extract CertificateFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  certificateFile;

		//	Try to initialize PrivateKeyFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  privateKeyFile;
		else {
			//	Try to initialize PrivateKeyFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  privateKeyFile;
		}
		//	And try to extract PrivateKeyFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  privateKeyFile;

		//	Try to initialize DHTempFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  dHTempFile;
		else {
			//	Try to initialize DHTempFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  dHTempFile;
		}
		//	And try to extract DHTempFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  dHTempFile;

		//	Try to initialize ExportedTables from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  exportedTables;
		else {
			//	Try to initialize ExportedTables from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  exportedTables;
		}
		//	And try to extract ExportedTables value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  exportedTables;

		//	Try to initialize AuthorisedUsers from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  authorisedUsers;
		else {
			//	Try to initialize AuthorisedUsers from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  authorisedUsers;
		}
		//	And try to extract AuthorisedUsers value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  authorisedUsers;

		//	Try to initialize LocalHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  localHost;
		else {
			//	Try to initialize LocalHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  localHost;
		}
		//	And try to extract LocalHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  localHost;

		//	Try to initialize LocalPort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  localPort;
		else {
			//	Try to initialize LocalPort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  localPort;
		}
		//	And try to extract LocalPort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  localPort;

		//	Try to initialize WorkerNumber from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  workerNumber;
		else {
			//	Try to initialize WorkerNumber from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  workerNumber;
		}
		//	And try to extract WorkerNumber value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  workerNumber;

		//	Try to initialize EnableSSL from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  enableSSL;
		else {
			//	Try to initialize EnableSSL from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  enableSSL;
		}
		//	And try to extract EnableSSL value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  enableSSL;

		//	Try to initialize DatabaseHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseHost;
		else {
			//	Try to initialize DatabaseHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseHost;
		}
		//	And try to extract DatabaseHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseHost;

		//	Try to initialize DatabasePort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databasePort;
		else {
			//	Try to initialize DatabasePort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databasePort;
		}
		//	And try to extract DatabasePort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databasePort;

		//	Try to initialize DatabaseUsername from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseUsername;
		else {
			//	Try to initialize DatabaseUsername from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseUsername;
		}
		//	And try to extract DatabaseUsername value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseUsername;

		//	Try to initialize DatabasePassword from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databasePassword;
		else {
			//	Try to initialize DatabasePassword from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databasePassword;
		}
		//	And try to extract DatabasePassword value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databasePassword;

		//	Try to initialize DatabaseConnectionNumber from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseConnectionNumber;
		else {
			//	Try to initialize DatabaseConnectionNumber from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseConnectionNumber;
		}
		//	And try to extract DatabaseConnectionNumber value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseConnectionNumber;

		//	Try to initialize AutoStart from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  autoStart;
		else {
			//	Try to initialize AutoStart from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  autoStart;
		}
		//	And try to extract AutoStart value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  autoStart;

	}

	/*----- PROTECTED REGION ID(DataExporter::get_device_property_after) ENABLED START -----*/

    try
    {
        if(enableSSL)
        {
            if(certificateFile.empty())
                throw(invalid_argument("CertificateFile property is empty or not defined"));

            checkIfFileExists(certificateFile);

            if(privateKeyFile.empty())
                throw(invalid_argument("PrivateKeyFile property is empty or not defined"));

            checkIfFileExists(privateKeyFile);

            if(dHTempFile.empty())
                throw(invalid_argument("DHTempFile property is empty or not defined"));

            checkIfFileExists(dHTempFile);
        }

        if(exportedTables.empty())
            throw(invalid_argument("ExportedTables property is empty or not defined"));

        importExportedTables(exportedTables, exportedTablesMap);

        if(authorisedUsers.empty())
            throw(invalid_argument("AuthorisedUsers property is empty or not defined"));

        importAuthorisedUsers(authorisedUsers, authorisedUsersMap);

        if(localHost.empty())
            throw(invalid_argument("LocalHost property is empty or not defined"));

        if(localPort<1 || localPort>MAX_PORT_NUMBER)
            throw(invalid_argument("LocalPort property out of range or not defined"));

        if(workerNumber<1 || workerNumber>MAX_WORKER_NUMBER)
            throw(invalid_argument("WorkerNumber property out of range or not defined"));

        if(databaseHost.empty())
            throw(invalid_argument("DatabaseHost property is empty or not defined"));

        if(databasePort<1 || databasePort>MAX_PORT_NUMBER)
            throw(invalid_argument("DatabasePort property out of range or not defined"));

        if(databaseUsername.empty())
            throw(invalid_argument("DatabaseUsername property is empty or not defined"));

        if(databasePassword.empty())
            throw(invalid_argument("DatabasePassword property is empty or not defined"));

        if(databaseConnectionNumber<1 || databaseConnectionNumber>MAX_DB_CONNECTION_NUMBER)
            throw(invalid_argument("DatabaseConnectionNumber property out of range or not defined"));

        m_configuration_sp = Configuration::create(certificateFile,
            privateKeyFile, dHTempFile, exportedTablesMap, authorisedUsersMap,
            localHost, localPort, workerNumber, databaseHost, databasePort,
            databaseUsername, databasePassword, databaseConnectionNumber);
    }
    catch(invalid_argument& ex)
    {
        set_state(Tango::FAULT);
        stringstream error_stream;
        error_stream << "DataExporter::get_device_property() " << ex.what() << endl;
        set_status(error_stream.str());
    }

	/*----- PROTECTED REGION END -----*/	//	DataExporter::get_device_property_after
}

//--------------------------------------------------------
/**
 *	Method      : DataExporter::always_executed_hook()
 *	Description : method always executed before any command is executed
 */
//--------------------------------------------------------
void DataExporter::always_executed_hook()
{
	DEBUG_STREAM << "DataExporter::always_executed_hook()  " << device_name << endl;
	/*----- PROTECTED REGION ID(DataExporter::always_executed_hook) ENABLED START -----*/

    if(get_state() != Tango::FAULT)
    {
        if(m_server_sp)
        {
            set_state(m_server_sp->readState());

            set_status(m_server_sp->readStatus());
        }
    }

	/*----- PROTECTED REGION END -----*/	//	DataExporter::always_executed_hook
}

//--------------------------------------------------------
/**
 *	Method      : DataExporter::read_attr_hardware()
 *	Description : Hardware acquisition for attributes
 */
//--------------------------------------------------------
void DataExporter::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "DataExporter::read_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(DataExporter::read_attr_hardware) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	DataExporter::read_attr_hardware
}


//--------------------------------------------------------
/**
 *	Method      : DataExporter::add_dynamic_attributes()
 *	Description : Create the dynamic attributes if any
 *                for specified device.
 */
//--------------------------------------------------------
void DataExporter::add_dynamic_attributes()
{
	/*----- PROTECTED REGION ID(DataExporter::add_dynamic_attributes) ENABLED START -----*/

	//	Add your own code to create and add dynamic attributes if any

	/*----- PROTECTED REGION END -----*/	//	DataExporter::add_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Command On related method
 *	Description: Activate data exporter
 *
 */
//--------------------------------------------------------
void DataExporter::on()
{
	DEBUG_STREAM << "DataExporter::On()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(DataExporter::on) ENABLED START -----*/

    try
    {
        if(m_server_sp)
            m_server_sp->start();
    }
    catch(std::exception& ex)
    {
        set_state(Tango::ALARM);
        std::stringstream error_stream;
        error_stream << "DataExporter::On() " << ex.what() << std::endl;
        set_status(error_stream.str());
    }
    catch(...)
    {
        set_state(Tango::ALARM);
        set_status("DataExporter::On() unknown error");
    }

	/*----- PROTECTED REGION END -----*/	//	DataExporter::on
}
//--------------------------------------------------------
/**
 *	Command Off related method
 *	Description: Deactivate data exporter
 *
 */
//--------------------------------------------------------
void DataExporter::off()
{
	DEBUG_STREAM << "DataExporter::Off()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(DataExporter::off) ENABLED START -----*/

    try
    {
        if(m_server_sp)
            m_server_sp->stop();
    }
    catch(std::exception& ex)
    {
        set_state(Tango::ALARM);
        std::stringstream error_stream;
        error_stream << "DataExporter::Off() " << ex.what() << std::endl;
        set_status(error_stream.str());
    }
    catch(...)
    {
        set_state(Tango::ALARM);
        set_status("DataExporter::Off() unknown error");
    }

	/*----- PROTECTED REGION END -----*/	//	DataExporter::off
}

/*----- PROTECTED REGION ID(DataExporter::namespace_ending) ENABLED START -----*/

//==============================================================================
//      DataExporter::importExportedTables()
//==============================================================================
void DataExporter::importExportedTables(std::vector<std::string>& exportedTables,
    std::multimap<const std::string, const std::string>& exportedTablesMap)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "DataExporter::importExportedTables()  - " << device_name << endl;

    for(unsigned int i=0; i<exportedTables.size(); ++i)
    {
        std::size_t found;

        if((found=exportedTables.at(i).find(',')) == std::string::npos)
        {
            std::stringstream errorStream;
            errorStream << "ExportedTables property has invalid key at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        std::string schema = exportedTables.at(i).substr(0, found);

        if(schema.empty())
        {
            std::stringstream errorStream;
            errorStream << "ExportedTables property has empty schema at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        std::string table = exportedTables.at(i).substr(found+1, std::string::npos);

        if(table.empty())
        {
            std::stringstream errorStream;
            errorStream << "ExportedTables property has empty table at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        INFO_STREAM << "DataExporter::importExportedTables() schema "
            << schema << " table " << table << endl;

        exportedTablesMap.insert(std::pair<const std::string, const std::string> (schema, table));
    }
}

//==============================================================================
//      DataExporter::importAuthorisedUsers()
//==============================================================================
void DataExporter::importAuthorisedUsers(std::vector<std::string>& authorisedUsers,
    std::map<const std::string, const std::string>& authorisedUsersMap)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "DataExporter::importAuthorisedUsers()  - " << device_name << endl;

    for(unsigned int i=0; i<authorisedUsers.size(); ++i)
    {
        std::size_t found;

        if((found=authorisedUsers.at(i).find(',')) == std::string::npos)
        {
            std::stringstream errorStream;
            errorStream << "AuthorisedUsers property has invalid key at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        std::string user = authorisedUsers.at(i).substr(0, found);

        if(user.empty())
        {
            std::stringstream errorStream;
            errorStream << "AuthorisedUsers property has empty user at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        std::string password = authorisedUsers.at(i).substr(found+1, std::string::npos);

        if(password.empty())
        {
            std::stringstream errorStream;
            errorStream << "AuthorisedUsers property has empty password at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        #ifdef VERBOSE_DEBUG
            INFO_STREAM << "DataExporter::importAuthorisedUsers() user "
                << user << " password " << password << endl;
        #endif

        authorisedUsersMap.insert(std::pair<const std::string,
            const std::string>(user, password));
    }
}

//==============================================================================
//      DataExporter::checkIfFileExists()
//==============================================================================
void DataExporter::checkIfFileExists(std::string fileName)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "DataExporter::checkIfFileExists()  - " << device_name << endl;

    boost::filesystem::path path(fileName);

    if(!boost::filesystem::exists(path))
    {
        std::stringstream errorStream;
        errorStream << "File " << fileName << " not exists" << std::endl;
        throw std::invalid_argument(errorStream.str());
    }

    INFO_STREAM << "DataExporter::checkIfFileExists() " << fileName << endl;
}

/*----- PROTECTED REGION END -----*/	//	DataExporter::namespace_ending
} //	namespace
