#ifndef SSLSERVER_H
#define	SSLSERVER_H

#include <Server.h>
#include <Configuration.h>

#include <boost/asio/ssl.hpp>

namespace DataExporter_ns
{

class SSLServer : public Server
{
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    SSLServer(Tango::DeviceImpl*, Configuration::SP);

    virtual ~SSLServer();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
	public:
		void operator()(SSLServer* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static Server::SP create(Tango::DeviceImpl*, Configuration::SP);

//------------------------------------------------------------------------------
//  [Protected] Incoming connection method
//------------------------------------------------------------------------------
    virtual void startAccept();

protected:
//------------------------------------------------------------------------------
//  [Protected] Utilities methods
//------------------------------------------------------------------------------
    virtual std::string getPassword();

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //SSL context shared pointer
    boost::shared_ptr<boost::asio::ssl::context> m_context_sp;
};

}   //End of namespace

#endif	/* SSLSERVER_H */

