/*----- PROTECTED REGION ID(DataExporterStateMachine.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        DataExporterStateMachine.cpp
//
// description : State machine file for the DataExporter class
//
// project :     Data exporter
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#include <DataExporter.h>

/*----- PROTECTED REGION END -----*/	//	DataExporter::DataExporterStateMachine.cpp

//================================================================
//  States  |  Description
//================================================================
//  ON      |  Data exporter is in ON state (ready to incoming connections)
//  OFF     |  Data exporter is in OFF state (not ready for incoming connections)
//  FAULT   |  Data exporter is in FAULT state (configuration error)
//  ALARM   |  Data exporter is in ALARM state (runtime error)


namespace DataExporter_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================

//=================================================
//		Commands Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : DataExporter::is_On_allowed()
 *	Description : Execution allowed for On attribute
 */
//--------------------------------------------------------
bool DataExporter::is_On_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::ON ||
		get_state()==Tango::FAULT ||
		get_state()==Tango::ALARM)
	{
	/*----- PROTECTED REGION ID(DataExporter::OnStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataExporter::OnStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataExporter::is_Off_allowed()
 *	Description : Execution allowed for Off attribute
 */
//--------------------------------------------------------
bool DataExporter::is_Off_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::OFF ||
		get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(DataExporter::OffStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	DataExporter::OffStateAllowed
		return false;
	}
	return true;
}

}	//	End of namespace
