#include <FileWrapper.h>

namespace DataExporter_ns
{

//==============================================================================
//      FileWrapper::FileWrapper()
//==============================================================================
FileWrapper::FileWrapper(Tango::DeviceImpl* deviceImpl_p,
    boost::filesystem::path& path) : Tango::LogAdapter(deviceImpl_p)
{
    DEBUG_STREAM << "FileWrapper::FileWrapper()" << endl;

    m_inputFileStream.open(path.string(), std::ios::binary | std::ios::ate);

    m_inputFileSize = m_inputFileStream.tellg();

    m_inputFileStream.seekg(0, m_inputFileStream.beg);
}

//==============================================================================
//      FileWrapper::~FileWrapper()
//==============================================================================
FileWrapper::~FileWrapper()
{
    DEBUG_STREAM << "FileWrapper::~FileWrapper()" << endl;

    m_inputFileStream.close();
}

//==============================================================================
//      FileWrapper::create()
//==============================================================================
FileWrapper::SP FileWrapper::create(Tango::DeviceImpl* deviceImpl_p,
    boost::filesystem::path& path)
{
    FileWrapper::SP d_sp(new FileWrapper(deviceImpl_p, path),
        FileWrapper::Deleter());

    return d_sp;
}

//==============================================================================
//      FileWrapper::isOpen()
//==============================================================================
bool FileWrapper::isOpen()
{
    return m_inputFileStream.is_open();
}

//==============================================================================
//      FileWrapper::isBad()
//==============================================================================
bool FileWrapper::isBad()
{
    return m_inputFileStream.bad();
}

//==============================================================================
//      FileWrapper::isCompleted()
//==============================================================================
bool FileWrapper::isCompleted()
{
    return (boost::uint64_t)m_inputFileStream.tellg() >= m_inputFileSize;
}

//==============================================================================
//      FileWrapper::read()
//==============================================================================
void FileWrapper::read(std::vector<char>& writeBuff)
{
    boost::uint64_t leftToRead = m_inputFileSize - m_inputFileStream.tellg();

    boost::uint64_t bufferSize = 0;

    if(leftToRead < BUFFER_SIZE)
            bufferSize = leftToRead;
    else
            bufferSize = BUFFER_SIZE;

    writeBuff.resize(bufferSize);

    m_inputFileStream.read(&writeBuff[0], bufferSize);
}

}
