#ifndef PROTOCOLMANAGER_H
#define	PROTOCOLMANAGER_H

#include <Response.pb.h>
#include <Request.pb.h>
#include <Configuration.h>
#include <DBManager.h>
#include <FileWrapper.h>

#include <tango.h>

#include <boost/filesystem.hpp>

namespace DataExporter_ns
{

//Protocol buffer request class shared pointer
typedef boost::shared_ptr<Request> RequestSP;

//Protocol buffer response class shared pointer
typedef boost::shared_ptr<Response> ResponseSP;

class ProtocolManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<ProtocolManager> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    ProtocolManager(Tango::DeviceImpl*, Configuration::SP, DBManager::SP);

    virtual ~ProtocolManager();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
            void operator()(ProtocolManager* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static ProtocolManager::SP create(Tango::DeviceImpl*, Configuration::SP,
        DBManager::SP);

//------------------------------------------------------------------------------
//	[Public] Remote endpoint setter method
//------------------------------------------------------------------------------
    void setRemoteEndpoint(std::string);

//------------------------------------------------------------------------------
//  [Public] Request response management method
//------------------------------------------------------------------------------
    virtual ResponseSP prepareResponse(RequestSP)
        throw(std::runtime_error);

//------------------------------------------------------------------------------
//  [Public] File transfer methods
//------------------------------------------------------------------------------
    bool isFileFound();

    FileWrapper::SP getFileWrapper() throw(std::runtime_error);

protected:
//------------------------------------------------------------------------------
//  [Protected] File path method
//------------------------------------------------------------------------------
    virtual boost::filesystem::path composePath(std::string, std::string,
        int, std::string);

//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Device implementation pointer
    Tango::DeviceImpl* m_deviceImpl_p;

    //Configuration parameters shared pointer
    Configuration::SP m_configuration_sp;

    //Database manger shared pointer
    DBManager::SP m_dBManager_sp;

    //Address and port of remote endpoint
    std::string m_remoteEndpoint;

    //File to transfer found
    bool m_fileFound;

    //File to transfer wrapper
    FileWrapper::SP m_fileWrapper_sp;
};

}   //End of namespace

#endif	/* PROTOCOLMANAGER_H */

