#!/bin/bash
#
# This Script allows to execute the conatiner using singularity
# in an isolated enviroment
#
# author <giuliano.taffoni@inaf.it>
#

# download the certificate from gitlab site
export SSL_CERT_FILE=DigiCertCA.crt

export CONTAINER_NAME="git.ia2.inaf.it:5050/lofarit/container_private/lofarit/ddfacet_kms_py3"
export CONTAINER_VERSION=0.1.0
export BASE_PORT=
if [ 'XXX'$1 = 'XXX' ]; then
    COMMAND=
else
    COMMAND=$1
fi
#export SINGULARITYENV_SAFE_MODE=True
HOMEDIR=`mktemp -d -t singularity_XXXXXXX`
mkdir $HOMEDIR/tmp
mkdir $HOMEDIR/home
singularity run  --pid --no-home --home=/home/lofar --workdir ${HOMEDIR}/tmp -B${HOMEDIR}:/home/ -B/beegfs:/beegfs --containall --cleanenv docker://${CONTAINER_NAME}:${CONTAINER_VERSION} $COMMAND
rm -fr ${HOMEDIR}
