#!/bin/bash
#
# This Script allows to execute the conatiner using singularity
# in an isolated enviroment
#
# author <giuliano.taffoni@inaf.it>
#

if [ 'XXX'$1 = 'XXX' ]; then
    COMMAND=/bin/bash
else
    COMMAND=$1
fi
CONTAINER_NAME="morgan1971/almagal"
CONTAINER_VERSION="v0.1.0"
export BASE_PORT=
export SINGULARITYENV_BASE_PORT=$BASE_PORT
export CONTAINER_NAME="docker://${CONTAINER_NAME}:${CONTAINER_VERSION}"

HOMEDIR=`mktemp -d -t singularity_XXXXXXX`
mkdir $HOMEDIR/tmp
mkdir $HOMEDIR/home
export FLAGS="--pid --writable-tmpfs --no-home --home=/home/metauser --workdir ${HOMEDIR}/tmp -B${HOMEDIR}:/home/  --containall --cleanenv"

singularity run  $FLAGS  ${CONTAINER_NAME} $COMMAND

rm -fr ${HOMEDIR}
